function Update() {
	if (GameManager.instance.CheckOcclusion(gameObject))
		renderer.material.renderQueue = 2000;
	else
		renderer.material.renderQueue = 3000 + 10;
		
	for(var x:Transform in transform)
	{
		if (rigidbody.velocity.magnitude < 0.3)
			x.transform.LookAt(GameManager.instance.follower.transform.position, Vector3.up);
		else
			x.transform.LookAt(transform.position + rigidbody.velocity, Vector3.up);
		x.position.y = 5*Mathf.Sin(Time.time*3);
	}
}


function FixedUpdate () {
	var d:Vector3 = transform.position - GameManager.instance.follower.transform.position;
	var d2:Vector3 = transform.position - GameManager.instance.player.transform.position;
	d.y = 0;
	d2.y = 0;
	
	if (d2.magnitude + 300 < d.magnitude)
		d = d2;

	rigidbody.drag = 0;
	if (d.magnitude < 300)
	{
		d = Vector3.Normalize(d);
		rigidbody.AddForce(-d*30);
	} else
		rigidbody.drag += 0.5;
	
	if (Vector3.Dot(-d, Vector3.Normalize(rigidbody.velocity)) < 0.7)//Mathf.Cos((Mathf.PI/180)*70))
		rigidbody.drag += 1;
	
	if (rigidbody.velocity.magnitude > 30)
		rigidbody.drag += 0.5;
}