﻿using System;
using System.Collections.Generic;
using System.Text;

namespace TheStory {
	public partial struct Color {
		uint color; // ARGB

		public uint ARGB {
			get { return color; }
		}

		public Color(byte red, byte green, byte blue, byte alpha) {
			color = (uint)(
				(red << 16) +
				(green << 8) +
				(blue << 0) +
				(alpha << 24));
		}

		public Color(float red, float green, float blue, float alpha) {
			color =
				((uint)(red * 255) << 16) +
				((uint)(green * 255) << 8) +
				((uint)(blue * 255) << 0) +
				((uint)(alpha * 255) << 24);
		}
	}

	public partial struct Color {
		public static Color Red { get { return new Color(255, 0, 0, 255); } }
		public static Color Black { get { return new Color(0, 0, 0, 255); } }
		public static Color White { get { return new Color(255, 255, 255, 255); } }
	}
}
