﻿using System;
using System.Collections.Generic;
using System.Text;
using Elf2D;
using Elf2D.Maths;
using Elf2D.Render;

namespace TheStory.Effects {
	class Explosion: Effect {
		Texture texture;
		Particle[] particles;


		internal override void Update(GameTime time) {
			int i;
			int count = particles.Length;
			int deadParticles = 0;

			for (i = 0; i < count; ++i) {
				if (particles[i].dead) {
					++deadParticles;
					continue;
				}

				particles[i].time += time.DeltaTime;
				if (particles[i].time > particles[i].lifeTime) {
					particles[i].time = particles[i].lifeTime;
					particles[i].dead = true;
					++deadParticles;
				}

				particles[i].position += particles[i].velocity * time.DeltaTime;
				particles[i].velocity.Length -= particles[i].velocity.Length * 2.0f * time.DeltaTime;
			}

			if (deadParticles == count) {
				Kill();
			}
		}

		internal override void Render() {
			texture.Bind();

			Quads.Begin();
			foreach (Particle particle in particles) {
				if (particle.dead) {
					continue;
				}

				Vector position = particle.position;
				float size = 15.0f;
				float alpha = (1.0f - particle.time / particle.lifeTime);
				Quads.SetColour(0x00FFFFFF | (uint)(alpha * 255.0f) << 24);
				Quads.SetTextureRectangle(0, 0, 1, 1);
				Quads.DrawRectangleCentered(position.x, position.y, size, size);
			}
			Quads.End();
		}

		internal Explosion(Texture texture, Vector position, int particlesNum) {
			this.texture = texture;
			this.particles = new Particle[particlesNum];

			Random rand = new Random();

			int i;
			for (i = 0; i < particlesNum; ++i) {
				particles[i].position = position;
				particles[i].velocity = Vector.RandomNormalized * (50.0f + (float)rand.NextDouble() * 200.0f);
				particles[i].lifeTime = 0.5f + (float)rand.NextDouble();
			}
		}
	}
}
