﻿using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using Elf2D.Render;
using Elf2D.Maths;

namespace TheStory {
	class Font {
		Dictionary<char, Glyph> glyphs;
		Texture texture;

		public float Size { get; private set; }
		public float Width { get; private set; }
		public float Height { get; private set; }


		public struct Glyph {
			public char symbol;
			public float u;
			public float v;
			public float width;

			public Glyph(char symbol, float u, float v, float width) {
				this.symbol = symbol;
				this.u = u;
				this.v = v;
				this.width = width;
			}
		}

		internal void Render(float x, float y, Color color, float size, string text) {
			texture.Bind();

			float scale = size / Size;

			int count = text.Length;
			int i;

			float currentX = x;
			Vector textureSize = new Vector((float)texture.Width, (float)texture.Height);

			Quads.Begin();
			Quads.SetColour(color.ARGB);
			for (i = 0; i < count; ++i) {
				char ch = text[i];
				if (char.IsWhiteSpace(ch)) {
					currentX += Width * 0.5f * scale;
					continue;
				}
				Glyph glyph = glyphs[ch];

				Quads.SetTextureRectangle(glyph.u / textureSize.x, glyph.v / textureSize.y, glyph.width / textureSize.x, Height / textureSize.y);
				Quads.DrawRectangle(currentX, y, glyph.width * scale, Height * scale);

				currentX += glyph.width * scale;
			}
			Quads.End();
		}

		public Font(string fontFile, string fontTextureFile) {
			Stream stream = File.OpenRead(fontFile);
			StreamReader reader = new StreamReader(stream);

			string line;

			line = reader.ReadLine();
			line = reader.ReadLine();
			Size = float.Parse(line = reader.ReadLine().Split(new char[]{'='})[1]);
			Width = int.Parse(line = reader.ReadLine().Split(new char[] { '=' })[1]);
			Height = int.Parse(line = reader.ReadLine().Split(new char[] { '=' })[1]);
			int glyphsCount = int.Parse(line = reader.ReadLine().Split(new char[] { '=' })[1]);

			glyphs = new Dictionary<char,Glyph>(glyphsCount);

			char[] splitChars = {' '};
			int i;
			for (i = 0; i < glyphsCount; ++i) {
				line = reader.ReadLine();
				string[] parts = line.Split(splitChars);
				char ch = char.Parse(parts[0]);
				glyphs.Add(ch, new Glyph(
					ch,
					int.Parse(parts[1]),
					int.Parse(parts[2]),
					int.Parse(parts[3])
				));
			}

			texture = Texture.Load(fontTextureFile, fontTextureFile);
		}
	}
}
