﻿using System;
using System.Collections.Generic;
using System.Text;
using Elf2D.Render;
using Elf2D.Maths;

namespace TheStory {
	class LoveIndicator {
		const float HeartSize = 40.0f;
		const float IndicatorWidth = 256.0f;

		Texture heartTexture;
		Texture maleTexture;
		Texture femaleTexture;

		float changeMaleTo = 100.0f;
		float changeFemaleTo = 100.0f;


		internal float MaleLove { get; private set; }
		internal float FemaleLove { get; private set; }


		internal void SetMale(float to) {
			changeMaleTo = to;
			if (changeMaleTo < 0.0f) {
				changeMaleTo = 0.0f;
			}
		}

		internal void SetFemale(float to) {
			changeFemaleTo = to;
			if (changeFemaleTo < 0.0f) {
				changeFemaleTo = 0.0f;
			}
		}

		internal void Update(Elf2D.GameTime time) {
			MaleLove = MathUtils.ChangeTowards(MaleLove, changeMaleTo, time.DeltaTime);
			FemaleLove = MathUtils.ChangeTowards(FemaleLove, changeFemaleTo, time.DeltaTime);
		}

		internal void Render() {
			float maleT = changeMaleTo / 100.0f;
			float femaleT = changeFemaleTo / 100.0f;

			heartTexture.Bind();
			Quads.Begin();
			Quads.SetColour(0xFFFFFFFF);
			Quads.SetTextureRectangle(0, 0, 1, 1);
			Quads.DrawRectangleCentered((float)Game.WindowWidth * 0.5f, (float)Game.WindowHeight - 35, HeartSize, HeartSize);
			Quads.End();

			maleTexture.Bind();
			Quads.Begin();
			Quads.SetColour(0xFFFFFFFF);
			Quads.SetTextureRectangle(0, 0, maleT, 1);
			Quads.DrawRectangle((float)Game.WindowWidth * 0.5f + 30.0f, (float)Game.WindowHeight - 48.0f, IndicatorWidth * maleT, 26.0f);
			Quads.End();

			femaleTexture.Bind();
			Quads.Begin();
			Quads.SetColour(0xFFFFFFFF);
			Quads.SetTextureRectangle(1.0f - femaleT, 0, femaleT, 1);
			Quads.DrawRectangle((float)Game.WindowWidth * 0.5f - 30.0f - IndicatorWidth * femaleT, (float)Game.WindowHeight - 48.0f, IndicatorWidth * femaleT, 26.0f);
			Quads.End();
		}

		internal LoveIndicator() {
			heartTexture = Texture.Load("IndicatorHeart", @"Data\IndicatorHeart.tga");
			maleTexture = Texture.Load("IndicatorMale", @"Data\IndicatorMale.tga");
			femaleTexture = Texture.Load("IndicatorFemale", @"Data\IndicatorFemale.tga");
		}
	}
}
