﻿using System;
using System.Collections.Generic;
using System.Text;
using Elf2D.Render;
using Elf2D.Maths;
using Elf2D.Input;
using Elf2D;
using TheStory.Effects;
using Elf2D.Audio;

namespace TheStory {
	enum PlayerGender {
		Male,
		Female
	}

	class Player {
		// Player size
		internal const float PlayerSize = 80.0f;
		internal const float PlayerRadius = PlayerSize / 2.0f;
		internal const float MaxSpeed = 600.0f;
		internal const float Acceleration = 800.0f;
		internal const float Deacceleration = 500.0f;
		internal const float PlayerDistanceFromSide = 50.0f;

		internal const float PlayerBorderLower = 30.0f;
		internal const float PlayerBorderUpper = (float)Game.WindowHeight - 80.0f;

		internal const float TakenEffectTime = 0.5f;


		PlayerGender gender;
		Texture texture;
		Vector position;
		Vector velocity;
		float love = 100;
		float takenTimer;

		Sound takeSoundGood;
		Sound takeSoundBad;


		internal float Love {
			get { return love; }
		}

		internal PlayerGender Gender {
			get { return gender; }
		}

		internal Vector Position {
			get { return position; }
			set { position = value; }
		}

		internal void Update(GameTime time) {
			if (takenTimer > 0.0f) {
				takenTimer -= time.DeltaTime;
				if (takenTimer < 0.0f) {
					takenTimer = 0.0f;
				}
			}

			/*
			if (Keyboard.IsKeyDown(Key.Up)) {
				velocity.y -= Acceleration * time.DeltaTime;
			} else if (Keyboard.IsKeyDown(Key.Down)) {
				velocity.y += Acceleration * time.DeltaTime;
			} else {
				velocity = MathUtils.ChangeTowards(velocity, Vector.Zero, Deacceleration * time.DeltaTime);
			}
			*/
			velocity = MathUtils.ChangeTowards(velocity, Vector.Zero, Deacceleration * time.DeltaTime);

			int mousePosX = 0;
			int mousePosY = 0;
			Mouse.GetPos(ref mousePosX, ref mousePosY);
			float accelerationAffection = (float)Math.Abs((float)(mousePosX - position.x));
			accelerationAffection = MathUtils.Clamp(accelerationAffection, 0.0f, (float)Game.WindowWidth);
			accelerationAffection = (1.0f - accelerationAffection / (float)Game.WindowWidth);
			accelerationAffection *= 2.0f;

			if (mousePosY < position.y) {
				velocity.y -= Acceleration * time.DeltaTime * accelerationAffection;
			} else if (mousePosY > position.y) {
				velocity.y += Acceleration * time.DeltaTime * accelerationAffection;
			} else {
				velocity = MathUtils.ChangeTowards(velocity, Vector.Zero, Deacceleration * time.DeltaTime);
			}

			velocity.y = MathUtils.Clamp(velocity.y, -MaxSpeed, MaxSpeed);

			position += velocity * time.DeltaTime;

			if (position.y < PlayerBorderLower) {
				position.y = PlayerBorderLower;
				velocity = -velocity * 0.3f;
			} else if (position.y > PlayerBorderUpper) {
				position.y = PlayerBorderUpper;
				velocity = -velocity * 0.3f;
			}
		}

		internal void Render() {
			float size = PlayerSize;
			if (takenTimer > 0.0f) {
				float t = 1.0f - takenTimer / TakenEffectTime;
				size += (float)Math.Sin(t * Math.PI * 2.0f * 3.0f) * (1.0f - t) * 6.0f;
			}

			texture.Bind();


			Quads.Begin();
			Quads.SetColour(0xFFFFFFFF);
			Quads.SetTextureRectangle(0, 0, 1, 1);
			Quads.DrawRectangleCentered(position.x, position.y, size, size);
			Quads.End();
		}

		internal float GetThrowDirection() {
			switch (gender) {
				case PlayerGender.Female:
					return 1.0f;

				case PlayerGender.Male:
					return -1.0f;
			}

			throw new Exception("Err..");
		}

		internal void OnCollision(Game game, Message message) {
			bool goodPick = false;

			switch (message.MessageType) {
				case MessageType.BadHeart:
					love -= 40.0f;
					break;

				case MessageType.BadTalk:
					love -= 40.0f;
					break;

				case MessageType.WWWWWWWWWWWWW:
					love -= 40.0f;
					break;

				case MessageType.Heart:
					love += 5.0f;
					goodPick = true;
					break;

				case MessageType.Present:
					love += 5.0f;
					goodPick = true;
					break;

				case MessageType.SweetTalk:
					love += 5.0f;
					goodPick = true;
					break;

				case MessageType.Phone:
					love += 5.0f;
					goodPick = true;
					break;

				case MessageType.Tv:
					love += 5.0f;
					goodPick = true;
					break;

				case MessageType.Broom:
					love += 5.0f;
					goodPick = true;
					break;

				default:
					throw new Exception();
			}

			love = MathUtils.Clamp(love, 0.0f, 100.0f);

			Texture texture;
			if (goodPick) {
				texture = Texture.Load("EffectHeart", @"Data\EffectHeart.tga");
				takeSoundGood.Play(0.9f);
			} else {
				texture = Texture.Load("EffectBroken", @"Data\EffectBroken.tga");
				takeSoundBad.Play(0.9f);
			}

			game.AddEffect(new Explosion(texture, message.Position, 50));

			takenTimer = TakenEffectTime;
		}

		internal void ChangeLove(float by) {
			love = MathUtils.Clamp(love + by, 0.0f, 100.0f);
		}

		internal Player(PlayerGender gender) {
			this.gender = gender;

			position.y = (float)Game.WindowHeight / 2.0f;

			switch (gender) {
				case PlayerGender.Male:
					texture = Texture.Load("male", @"Data\Male.tga");
					position.x = (float)Game.WindowWidth - PlayerDistanceFromSide;
					break;

				case PlayerGender.Female:
					texture = Texture.Load("female", @"Data\Female.tga");
					position.x = PlayerDistanceFromSide;
					break;
			}

			takeSoundGood = Sound.Load("TakeGood", @"Data\Sounds\TakeGood.wav");
			takeSoundBad = Sound.Load("TakeBad", @"Data\Sounds\TakeBad.wav");
		}

		internal void Reset() {
			position.y = (float)Game.WindowWidth / 2;
			velocity.Set(0, 0);
			love = 100;
			takenTimer = 0.0f;
		}
	}
}
