﻿using System;
using System.Collections.Generic;
using System.Text;
using Elf2D.Render;
using Elf2D;

namespace TheStory {
	class MainGameLoop {
		enum State {
			Menu,
			Game,
			Ending
		}

		State state = State.Menu;
		//State state = State.Game;
		MainMenu menu;
		Game game;
		Font font;
		TheEnd end;


		private void Update(float deltaTime) {
			//System.Console.WriteLine(deltaTime);
			if (deltaTime > 1.0f / 60.0f) {
				deltaTime = 1.0f / 60.0f;
			}

			switch (state) {
				case State.Menu:
					menu.Update(deltaTime);
					if (menu.HasEnded) {
						state = State.Game;
						game.Reset();
					}
					break;

				case State.Game:
					game.Update(deltaTime);
					if (game.HasEnded) {
						state = State.Ending;
						end.Reset();
					}
					break;

				case State.Ending:
					end.Update(deltaTime);
					if (end.HasEnded) {
						state = State.Menu;
						menu.Reset();
					}
					break;
			}
		}


		private void Render(float deltaTime) {
			Video.Clear(0xFFFFFFFF);
			Video.EnableBlending(true);

			switch (state) {
				case State.Menu:
					menu.Render();
					break;

				case State.Game:
					game.Render();
					break;

				case State.Ending:
					game.Render();
					end.Render();
					break;
			}
		}

		private void Init() {
			font = new Font(@"Data\Fonts\Font.fnt", @"Data\Fonts\Font.tga");

			menu = new MainMenu(font);
			game = new Game();
			game.Init();
			end = new TheEnd(font);
		}

		public void Run() {
			Core.PreloadElf2DDll(@"Elf2D.dll");
			Core.PreloadElf2DDll(@"..\..\..\Dll\Elf2D.dll");
			Core.PreloadElf2DDll(@"..\..\..\..\..\Dll\Elf2D.dll");

			Core.ConfigSetWindowParams(Game.WindowWidth, Game.WindowHeight, true, "The Story");
			Core.ConfigSetUpdateCallback(Update);
			Core.ConfigSetRenderCallback(Render);
			Core.ConfigSetSystemLogMode(LogMode.STDOut);

			if (Core.Initialise()) {
				Init();
				FreeConsole();
				Core.Run();
				Core.Shutdown();
			}
		}

		[System.Runtime.InteropServices.DllImport("kernel32.dll")]
		public static extern bool FreeConsole();
	}
}
