﻿using System;
using System.Collections.Generic;
using System.Text;
using Elf2D.Maths;
using Elf2D.Render;
using Elf2D.Input;

namespace TheStory {
	class MainMenu {
		enum State {
			Intro,
			Menu
		}

		State state = State.Intro;
		float introTime = 0.0f;
		Font font;
		static float allTime;


		internal bool HasEnded { get; private set; }

		internal void Update(float deltaTime) {
			allTime += deltaTime;

			switch (state) {
				case State.Intro:
					UpdateIntro(deltaTime);
					break;

				case State.Menu:
					UpdateMenu(deltaTime);
					break;
			}
		}

		internal void Render() {
			switch (state) {
				case State.Intro:
					RenderIntro();
					break;

				case State.Menu:
					RenderMenu();
					break;
			}

		}

		private void UpdateMenu(float deltaTime) {
			if (Mouse.IsButtonDown(MouseKey.Left)) {
				int x = 0, y = 0;
				Mouse.GetPos(ref x, ref y);

				if (x > 650 && x < 750 && y > 510 && y < 550) {
					HasEnded = true;
				}
			}
		}

		private void RenderMenu() {
			float t = (float)Math.Sin(allTime * 10.0f);

			Color color = new Color(0.0f, 0.0f, 0.0f, 0.8f + t * 0.2f);

			//font.Render(500, 500, color, 20, "INVISIBLE FRIEND");
			font.Render(700, 530, color, 20, "PLAY");
		}

		private void UpdateIntro(float deltaTime) {
			//deltaTime *= 5.0f;

			if (introTime < 50.0f) {
				introTime += deltaTime;
			}

		}

		private void RenderIntro() {
			float t;

			if (MathUtils.IsBetweanAndMap(introTime, 0, 1, out t)) {
				Video.Clear(0xFF000000);
			}

			if (MathUtils.IsBetweanAndMap(introTime, 1, 4, out t)) {
				Video.Clear(new Color(t, t, t, 0.0f).ARGB);
			}

			if (introTime < 10.0f) {
				float theStory;
				if (!MathUtils.IsBetweanAndMap(introTime, 1, 10, out theStory)) {
					theStory = 1.0f;
				}
				float theStoryAlpha;
				if (MathUtils.IsBetweanAndMap(introTime, 8, 10, out theStoryAlpha)) {
					theStoryAlpha = 1 - theStoryAlpha;
				} else {
					theStoryAlpha = 1.0f;
				}
				font.Render(400, 400, new Color(0, 0, 0, theStoryAlpha), 70 + theStory * 10, "STORY");
			}

			float menu;
			if (MathUtils.IsBetweanAndMap(introTime, 10, 10.5f, out menu)) {
				menu = 1 - menu;
				//font.Render(500 + menu * 400, 500, Color.Black, 20, "INVISIBLE FRIEND");
				//font.Render(500 + menu * 500, 530, Color.Black, 20, "REAL FRIEND");
				font.Render(700 + menu * 200, 530, Color.Black, 20, "PLAY");

			}

			if (introTime >= 10.5f) {
				state = State.Menu;
			}
		}

		internal MainMenu(Font font) {
			this.font = font;
		}

		internal void Reset() {
			allTime = 0.0f;
			introTime = 0.0f;
			HasEnded = false;
		}
	}
}
