﻿using System;
using System.Collections.Generic;
using System.Text;
using Elf2D.Maths;
using Elf2D.Render;

namespace TheStory {
	class TheEnd {
		internal bool HasEnded;
		float endTime;
		Font font;

		internal void Update(float deltaTime) {
			endTime += deltaTime;

		}

		internal void Render() {
			float t;
			MathUtils.IsBetweanAndMap(endTime, 0.0f, 2.0f, out t);
			Texture.Unbind();
			Quads.Begin();
			Quads.SetColour(new Color(1,1,1,t).ARGB);
			Quads.SetTextureRectangle(0, 0, 1, 1);
			Quads.DrawRectangle(0, 0, Game.WindowWidth, Game.WindowHeight);
			Quads.End();

			if (MathUtils.IsBetweanAndMap(endTime, 2.0f, 4.0f, out t)) {
				font.Render(330, 250, new Color(0, 0, 0, t), 30, "THE END");
			}
			if (endTime > 4.0f) {
				font.Render(330, 250, new Color(0, 0, 0, 1.0f), 30, "THE END");
			}

			if (MathUtils.IsBetweanAndMap(endTime, 8.0f, 100.0f, out t)) {
				HasEnded = true;
			}
		}

		internal TheEnd(Font font) {
			this.font = font;
		}

		internal void Reset() {
			endTime = 0.0f;
			HasEnded = false;
		}
	}
}
