#include "mapas.hpp"


KMapas::KMapas()
{
}


KMapas::~KMapas()
{
}


void KMapas::Sukurti()
{
	tekstZeme = teksturos.ID("zeme.tga");
	tekstSiena = teksturos.ID("siena.tga");
	//Sukuriamas zemelapis
	for(int i = 0; i < MAPAS_X; i++)
		for(int j = 0; j < MAPAS_Y; j++)
			map[i][j] = rand() % 2 - 1;
}


bool KMapas::Laisva(int _x, int _y)
{
	if(_x < 0 || _x >= MAPAS_X || _y < 0 || _y >= MAPAS_Y)
		return false;
	return (map[_x][_y] == 0);
}


int KMapas::Susidurimas(KTaskas &poz)
{
	int x = int(poz.x / float(MAPAS_DYDIS));
	int y = int(poz.y / float(MAPAS_DYDIS));
	//Logas::Log("%i %i  %.2f  %.2f  %.2f", x, y, poz.x, poz.y, MAPAS_DYDIS);
	if(x < 0 || x >= MAPAS_X || y < 0 || y >= MAPAS_Y)
		return 0;
	if(map[x][y] < 0){
		return map[x][y]++;
	}
	return map[x][y];
}


void KMapas::Atnaujinti()
{
}


void KMapas::Piesti()
{
	glPushMatrix();
	for(int i = 0; i < MAPAS_X; i++){
		glPushMatrix();
		for(int j = 0; j < MAPAS_Y; j++){
			if(map[i][j] == -1)
				glBindTexture(GL_TEXTURE_2D, tekstSiena);
			else
				glBindTexture(GL_TEXTURE_2D, tekstZeme);
			Geom::Plokst(MAPAS_DYDIS);
			glTranslatef(0.0, MAPAS_DYDIS, 0.0);
		}
		glPopMatrix();
		glTranslatef(MAPAS_DYDIS, 0.0, 0.0);
	}
	glPopMatrix();
}


void KMapas::Naikinti()
{
}
