#include "pagr.hpp"


int main()
{
	srand(time(NULL));
	nust.Uzkrauti("settings.cfg");
	pele.Params(nust);
	langas.Sukurti();
	OglExt::Sukurti(langas.hDC);
	Geom::Sukurti();
	JoystickDevs::Sukurti();
	if(JoystickDevs::sk > 0)
		joy = &JoystickDevs::devs[0];
	laikas.Sukurti();	
	OpenGL::Init(nust);
	glDisable(GL_DEPTH_TEST);
	garsai.Sukurti();
	garsai.Uzkrauti("duomenys/");
	muzika.Sukurti("duomenys/muzika.ogg", &poz, true);
	muzika.Groti();
	gars.Sukurti(garsai.ID("suvis.wav"), &poz, false);
	
	teksturos.Uzkrauti("duomenys/");
	rodykle.Sukurti();
	intro.Sukurti();
	pagalba.Sukurti();
	meniu.Sukurti();
	
	mapas.Sukurti();
	KTankas::mapas = &mapas;
	tankaiLT.Sukurti(5, MAPAS_X / 2, 0, teksturos.ID("LT.tga"));
	tankaiRU.Sukurti(10, MAPAS_X / 2, MAPAS_Y - 1, teksturos.ID("RU.tga"));
	ZaidejasPrijungti(0);
	tankas.Sukurti(0, 0, teksturos.ID("LT.tga"));
	
	if(!tekstas.Sukurti(langas.hDC))
		;//Logas::Log("Tekstas nesukurtas");
	laikas.Gauti();
	while(!baigti){
		laikas.Gauti();
		klav.Atnaujinti();
		langas.Atnaujinti();
		JoystickDevs::Atnaujinti();
		muzika.Atnaujinti();
		Atnaujinti();
		Piesti();
		langas.SukeistiBuferius();
		if(langas.baigti)
			baigti = true;
	}
	mapas.Naikinti();
	Geom::Naikinti();
	garsai.Naikinti();
	langas.Naikinti();
}


void ZaidejasPrijungti(int _zaidNum)
{
	if(tankaiLT.gyvu == 0)
		return;
	if(_zaidNum >= tankaiLT.sk)
		_zaidNum = 0;
	while(!tankaiLT.tankai[_zaidNum].gyvas){
		++_zaidNum;
		if(_zaidNum >= tankaiLT.sk)
			_zaidNum = 0;
	}
	tankaiLT.tankai[zaidNum].IjungtiAI();
	zaidNum = _zaidNum;
	zaidejas = &tankaiLT.tankai[zaidNum];
	zaidejas->IjungtiZaid();
	rodykle.Nustatyti(&zaidejas->poz);
}


void Atnaujinti()
{
	if(klav.sp[VK_F2] == 2)
		JoystickDevs::Kalibruoti();
	if(klav.sp[VK_F1] == 2)
		pagalba.Rodyti(true);
	if(klav.sp[VK_F1] == 1)
		pagalba.Rodyti(false);
	if(klav.sp[VK_F3] == 2)
		gars.Groti();
	gars.Atnaujinti();
	
	switch(faze){
		case F_INTRO:
		{
			if(intro.baigta || klav.sp[VK_SPACE] == 2 || klav.sp[VK_RETURN] == 2){
				//Logas::Log("Meniu");
				faze = F_MENIU;
			}
			break;
		}
		case F_MENIU:
		{
			if(klav.sp[VK_DOWN] == 2)
				meniu.Pasir(1);
			if(klav.sp[VK_UP] == 2)
				meniu.Pasir(-1);
			if(joy != NULL){
				if(joy->asis[1] > 0.5)
					meniu.Pasir(1);
				if(joy->asis[1] < -0.5)
					meniu.Pasir(-1);
			}
			if(klav.sp[VK_RETURN] == 2){
				if(meniu.pasir == 0){
					mapas.Sukurti();
					KTankas::Init();
					tankaiLT.Sukurti(5, MAPAS_X / 2, 0, teksturos.ID("LT.tga"));
					tankaiRU.Sukurti(10, MAPAS_X / 2, MAPAS_Y - 1, teksturos.ID("RU.tga"));
					ZaidejasPrijungti(0);
					meniu.laimeta = false;
					meniu.pereita = false;
					faze = F_ZAIDIMAS;
				}
				else if(meniu.pasir == 1){
					faze = F_PAGALBA;
					pagalba.Rodyti(true);
				}
				else{
					faze = F_PABAIGA;
					baigti = true;
				}
			}
			break;
		}
		case F_PAGALBA:
			if(klav.sp[VK_RETURN] == 2){
				faze = F_MENIU;
				pagalba.Rodyti(false);
			}
			break;
		case F_ZAIDIMAS:
		{
			//Zaidejo valdymas
			//Persijungimas i kita tanka
			if(klav.sp['S'] == 2)
				ZaidejasPrijungti(zaidNum + 1);
			if(joy != NULL)
				if(joy->sp[7] == 2)
					ZaidejasPrijungti(zaidNum + 1);
			//Vaziavimas
			if(klav.sp[VK_LEFT] >= 2)
				zaidejas->Kairen();
			if(klav.sp[VK_RIGHT] >= 2)
				zaidejas->Desinen();
			if(klav.sp[VK_UP] >= 2)
				zaidejas->Aukstyn();
			if(klav.sp[VK_DOWN] >= 2)
				zaidejas->Zemyn();
			if(joy != NULL){
				if(joy->asis[0] < -0.5)
					zaidejas->Kairen();
				if(joy->asis[0] > 0.5)
					zaidejas->Desinen();
				if(joy->asis[1] > 0.5)
					zaidejas->Zemyn();
				if(joy->asis[1] < -0.5)
					zaidejas->Aukstyn();
			}
			//Vamzdis
			if(klav.sp['A'] >= 2)
				zaidejas->Vamzdis(1.0);
			if(klav.sp['D'] >= 2)
				zaidejas->Vamzdis(-1.0);
			if(joy != NULL)
				zaidejas->Vamzdis(-joy->asis[3] * 2.0);
			//Saudymas
			if(klav.sp[VK_SPACE] >= 2)
				zaidejas->Sauti();
			if(joy != NULL)
				if(joy->sp[0] >= 2 || joy->sp[6] >= 2)
					zaidejas->Sauti();
			
			mapas.Atnaujinti();
			tankaiLT.Atnaujinti();
			tankaiRU.Atnaujinti();
			
			//Tikrinti kulkas
			AtnaujintiKulkas(tankaiLT);
			AtnaujintiKulkas(tankaiRU);
			
			if(klav.sp[VK_ESCAPE] == 2)
				faze = F_MENIU;
			if(tankaiLT.gyvu == 0){
				meniu.pereita = true;
				meniu.laimeta = false;
				faze = F_MENIU;
			}
			if(tankaiRU.gyvu == 0){
				meniu.pereita = true;
				meniu.laimeta = true;
				faze = F_MENIU;
			}
			break;
		}
	}
}


void AtnaujintiKulkas(KTankai &tankai)
{
	int susid;
	//Logas::Log("%i", tankaiLT.sk);
	for(int i = 0; i < tankai.sk; i++){
		if(tankai.tankai[i].issauta){
			susid = mapas.Susidurimas(tankai.tankai[i].kulka);
			if(susid == tankai.tankai[i].num || susid == 0)
				continue;
			if(susid < 0){
				//Pataike i siena
				tankai.tankai[i].NaikintiKulka();
			}
			else{
				//Pataike i tanka
				if(susid <= 5){	//Pataike i LT
					if(tankai.tankai[i].kulka.Atstumas(tankaiLT.tankai[susid - 1].poz) < 20.0){
						tankaiLT.tankai[susid - 1].Pataikyta();
						tankai.tankai[i].NaikintiKulka();
					}
				}
				else{			//Pataike i RU
					if(tankai.tankai[i].kulka.Atstumas(tankaiRU.tankai[susid - 1 - tankaiLT.sk].poz) < 20.0){
						tankaiRU.tankai[susid - 1 - tankaiLT.sk].Pataikyta();
						tankai.tankai[i].NaikintiKulka();
					}
				}
			}
			//Logas::Log("Pataikyta");
		}
	}
}


void Piesti()
{
	glClear(GL_COLOR_BUFFER_BIT);
	OpenGL::Ortho(0, 0, 800, 600, 100, -100);
	
	glColor4f(1.0, 1.0, 1.0, 1.0);
	glEnable(GL_TEXTURE_2D);
	
	switch(faze){
		case F_INTRO:
			intro.Piesti();
			break;
		case F_MENIU:
			meniu.Piesti();
			break;
		case F_PAGALBA:
			break;
		case F_ZAIDIMAS:
			glPushMatrix();
			glTranslatef(25.0, 5.0, 0.0);
			mapas.Piesti();
			tankaiLT.Piesti();
			tankaiRU.Piesti();
			rodykle.Piesti();
			glScalef(10.0, 10.0, 10.0);
			//tankas.Piesti();
			glDisable(GL_TEXTURE_2D);
			//glTranslatef(5.0, 5.0, 0.0);
			//MapasPiesti();
			glPopMatrix();
			//glDisable(GL_TEXTURE_2D);
			
			//Piesiami JoyStick'ai
			/*for(int i = 0; i < JoystickDevs::sk; i++){
				glPushMatrix();
				glTranslatef(5.0, 100.0 * i + 50.0, 0.0);
				PiestiJoystick(JoystickDevs::devs[i]);
				glPopMatrix();
			}*/
			break;
	}
	
	glColor4f(1.0, 1.0, 1.0, 1.0);
	//glRasterPos2i(5, 550);
	//tekstas.PiestiNF("FPS: %i  %i", laikas.fps, tankaiLT.gyvu);
	
	pagalba.Piesti();
}


void MapasPiesti()
{
	for(int i =0; i < MAPAS_X; i++)
		for(int j = 0; j < MAPAS_Y; j++){
			glRasterPos2f(i * MAPAS_DYDIS, j * MAPAS_DYDIS);
			tekstas.PiestiNF("%i", mapas.map[i][j]);
		}
}


void PiestiJoystick(KJoystick &joy)
{
	//Piesiami spaudukai
	glPushMatrix();
	for(int i = 0; i < joy.infSpSk; i++){
		if(joy.sp[i] >= 2)
			glColor3f(0.0, 1.0, 0.0);
		else
			glColor3f(0.5, 0.0, 0.0);
		Geom::Plokst(14.0, 10.0);
		
		glColor3f(1.0, 1.0, 1.0);
		Geom::PlokstWire(14.0, 10.0);
		glRasterPos2i(0, 0);
		tekstas.PiestiNF("%i", (i + 1));
		glTranslatef(16.0, 0.0, 0.0);
	}
	glPopMatrix();
	
	//Piesiamos asys
	for(int i = 0; i < joy.infAsiuSk; i++){
		glTranslatef(0.0, 12.0, 0.0);
		glColor3f(1.0, 1.0, 1.0);
		Geom::PlokstWire(100.0, 10.0);
		glColor3f(0.0, 1.0, 0.0);
		glPushMatrix();
		glTranslatef(joy.asis[i] * 50.0 + 50.0, 0.0, 0.0);
		Geom::Plokst(2.0, 10.0);
		glPopMatrix();
		glPushMatrix();
		glTranslatef(110.0, 0.0, 0.0);
		glRasterPos2i(0, 0);
		tekstas.PiestiNF("%.3f", joy.asis[i]);
		glPopMatrix();
	}
}
