#include "tankas.hpp"


KMapas * KTankas::mapas = NULL;
int KTankas::sk = 0;


KTankas::KTankas(): pas(0), vamzdisPas(0.0), sov(0), tekst(0), kulkaGr(4.0),
  gyvas(false), issauta(false), vaziuoja(false), ai(true)
{
}


KTankas::~KTankas()
{
}


void KTankas::Init()
{
	sk = 0;
}


void KTankas::Sukurti(int _x, int _y, GLuint _tekst)
{
	num = ++sk;
	xNauj = x = _x;
	yNauj = y = _y;
	poz.x = MAPAS_DYDIS * (x + 0.5);
	poz.y = MAPAS_DYDIS * (y + 0.5);
	tekst = _tekst;
	if(y > MAPAS_Y / 2){
		pas = 2;
		vamzdisPas = 180.0;
	}
	else{
		pas = 0;
		vamzdisPas = 0.0;
	}
	mapas->map[x][y] = num;
	suvioLaikas = 0.1 * (rand() % 300);
	gyvybe = 3;
	gyvas = true;
	issauta = false;
	vaziuoja = false;
	ai = true;
	
	Logas::Log("%i  %i", garsai.ID("suvis.wav"), garsai.ID("sprogimas.wav"));
	gSuvis.Sukurti(garsai.ID("suvis.wav"), &gPoz, false);
	gSprogimas.Sukurti(garsai.ID("sprogimas.wav"), &gPoz, false);
}


void KTankas::IjungtiAI()
{
	ai = true;
}


void KTankas::IjungtiZaid()
{
	ai = false;
	susid = false;
}


void KTankas::Pataikyta()
{
	if(--gyvybe <= 0)
		Zuvo();
}


bool KTankas::Vaziuoti()
{
	switch(pasNauj){
		case 1:
			return Kairen();
		case 3:
			return Desinen();
		case 2:
			return Zemyn();
		case 0:
			return Aukstyn();
		default:
			return false;
	}
}


void KTankas::IeskotiPriesu(int _x, int _y)
{
	int x2 = x, y2 = y;
	obj = num;
	while(x2 >= 0 && x2 < MAPAS_X && y2 >= 0 && y2 < MAPAS_Y && (obj == num || obj == 0)){
		obj = mapas->map[x2][y2];
		x2 += _x;
		y2 += _y;
	}
	if(obj != num && obj > 0){
		//Susidurimas su tanku
		if((num < 6 && obj > 5) || (num > 5 && obj < 6)){
			//Logas::Log("%i %i  %i %i", num, obj, _x, _y);
			//Susidurimas su priesu
			if(_x == -1)
				susidPas = 90.0;
			else if(_y == -1)
				susidPas = 180.0;
			else if(_x == 1)
				susidPas = 270.0;
			else
				susidPas = 0.0;
			susid = true;
		}
	}
}


void KTankas::Atnaujinti()
{
	if(!gyvas)
		return;
	if(ai){
		susid = false;
		if(suvioLaikas > 1.5){
			//Tikrinti, ar nera priesu
			IeskotiPriesu(-1, 0);
			IeskotiPriesu(1, 0);
			IeskotiPriesu(0, -1);
			IeskotiPriesu(0, 1);
		}
		if(!vaziuoja){
			//Vaziuoti atsitiktine kryptimi
			if(!susid){
				if(!Vaziuoti()){
					pas = pasNauj;
					do{ pasNauj = rand() % 4; }
					while(pas == pasNauj);
					Vaziuoti();
				}
			}
			else{
				//Taikytis i priesa
				if(Matke::KampaiSkirt(susidPas, vamzdisPas) < 0.0)
					vamzdisPas += 50.0 * laikas.kadro;
				else
					vamzdisPas -= 50.0 * laikas.kadro;
				if(abs(vamzdisPas - susidPas) < 1.0)
					Sauti();
			}
		}
		if(suvioLaikas > 40.0 && !issauta){
			//Jei ilgai nesaude - bandyti sauti
			int _x = 0, _y = 0;
			if(pas % 2 == 1)
				_x = 2 - pas;
			else
				_y = 1 - pas;
			IeskotiPriesu(_x, _y);
			if(obj < 0)
				Sauti();
		}
	}
	suvioLaikas += laikas.kadro;
	pas = pasNauj;
	if(issauta){
		kulka.x += -sin(kulkaPas * M_PI / 180.0) * kulkaGr;
		kulka.y += cos(kulkaPas * M_PI / 180.0) * kulkaGr;
		if(kulka.x < 0.0 || kulka.x > 800.0 || kulka.y < 0.0 || kulka.y > 600.0)
			issauta = false;
	}
	if(vaziuoja){
		poz += (pozNauj - poz).IlgisMaks(1.0);
		if((pozNauj - poz).Ilgis() < 0.1){
			//Atvaziavo
			vaziuoja = false;
			mapas->map[x][y] = 0;
			x = xNauj;
			y = yNauj;
		}
	}
	gSuvis.Atnaujinti();
	gSprogimas.Atnaujinti();
}


void KTankas::Piesti()
{
	if(!gyvas)
		return;
	glBindTexture(GL_TEXTURE_2D, tekst);
	glPushMatrix();
	glTranslatef(poz.x, poz.y, 0.0);
	//Tanko pagrindas
	glPushMatrix();
	glRotatef(pas * 90.0, 0.0, 0.0, 1.0);
	glBegin(GL_QUADS);
		glNormal3f(0.0, 0.0, 1.0);
		glTexCoord2f(0.0, 0.0);		glVertex3f(-12.0, -12.0, 0.0);
		glTexCoord2f(0.44, 0.0);		glVertex3f(12.0, -12.0, 0.0);
		glTexCoord2f(0.44, 1.0);		glVertex3f(12.0, 12.0, 0.0);
		glTexCoord2f(0.0, 1.0);		glVertex3f(-12.0, 12.0, 0.0);
	glEnd();
	glPopMatrix();
	//Soviniai
	glPushMatrix();
	//glTranslatef(5.0, 5.0, 0.0);
	glRotatef(vamzdisPas, 0.0, 0.0, 1.0);
	glTranslatef(0.0, 7.0, 0.0);
	glBegin(GL_QUADS);
		glNormal3f(0.0, 0.0, 1.0);
		glTexCoord2f(0.45, 0.0);		glVertex3f(-7.0, -14.0, 0.0);
		glTexCoord2f(0.7, 0.0);		glVertex3f(7.0, -14.0, 0.0);
		glTexCoord2f(0.7, 1.0);		glVertex3f(7.0, 14.0, 0.0);
		glTexCoord2f(0.45, 1.0);		glVertex3f(-7.0, 14.0, 0.0);
	glEnd();
	glPopMatrix();
	//Vamzdis
	//
	glPopMatrix();
	//Kulka
	if(issauta){
		glPushMatrix();
		glTranslatef(kulka.x, kulka.y, 0.0);
		glRotatef(kulkaPas, 0.0, 0.0, 1.0);
		glBegin(GL_QUADS);
			glNormal3f(0.0, 0.0, 1.0);
			glTexCoord2f(0.9, 0.0);		glVertex3f(-5.0, -10.0, 0.0);
			glTexCoord2f(0.99, 0.0);		glVertex3f(5.0, -10.0, 0.0);
			glTexCoord2f(0.99, 1.0);		glVertex3f(5.0, 10.0, 0.0);
			glTexCoord2f(0.9, 1.0);		glVertex3f(-5.0, 10.0, 0.0);
		glEnd();
		glPopMatrix();
	}
}


void KTankas::Naikinti()
{
	gyvas = false;
}


bool KTankas::Kairen()
{
	//Logas::Log("Kairen");
	if(!vaziuoja && mapas->Laisva(x - 1, y)){
		xNauj = x - 1;
		yNauj = y;
		pozNauj.x = poz.x - MAPAS_DYDIS;
		pozNauj.y = poz.y;
		pasNauj = 1;
		vaziuoja = true;
		mapas->map[xNauj][yNauj] = num;
		return true;
	}
	else
		return false;
}


bool KTankas::Desinen()
{
	//Logas::Log("Desinen");
	if(!vaziuoja && mapas->Laisva(x + 1, y)){
		xNauj = x + 1;
		yNauj = y;
		pozNauj.x = poz.x + MAPAS_DYDIS;
		pozNauj.y = poz.y;
		pasNauj = 3;
		vaziuoja = true;
		mapas->map[xNauj][yNauj] = num;
		return true;
	}
	else
		return false;
}


bool KTankas::Zemyn()
{
	//Logas::Log("Zemyn");
	if(!vaziuoja && mapas->Laisva(x, y - 1)){
		xNauj = x;
		yNauj = y - 1;
		pozNauj.x = poz.x;
		pozNauj.y = poz.y - MAPAS_DYDIS;
		pasNauj = 2;
		vaziuoja = true;
		mapas->map[xNauj][yNauj] = num;
		return true;
	}
	else
		return false;
}


bool KTankas::Aukstyn()
{
	//Logas::Log("Aukstyn");
	if(!vaziuoja && mapas->Laisva(x, y + 1)){
		xNauj = x;
		yNauj = y + 1;
		pozNauj.x = poz.x;
		pozNauj.y = poz.y + MAPAS_DYDIS;
		pasNauj = 0;
		vaziuoja = true;
		mapas->map[xNauj][yNauj] = num;
		return true;
	}
	else
		return false;
}


void KTankas::Vamzdis(float _pas)
{
	vamzdisPas += _pas;
}


void KTankas::Sauti()
{
	if(gyvas && !issauta && suvioLaikas > 1.5){
		issauta = true;
		susid = false;
		suvioLaikas = 0.0;
		kulkaPas = vamzdisPas;
		kulka.x = poz.x - sin(kulkaPas * M_PI / 180.0) * 10.0;
		kulka.y = poz.y + cos(kulkaPas * M_PI / 180.0) * 10.0;
		gSuvis.Groti();
	}
}


void KTankas::NaikintiKulka()
{
	issauta = false;
}


void KTankas::Zuvo()
{
	Logas::Log("Zuvo: %i", num);
	mapas->map[x][y] = 0;
	mapas->map[xNauj][yNauj] = 0;
	gyvas = false;
	gSprogimas.Groti();
}
