#ifndef TANKAS_HPP
#define TANKAS_HPP
#include <defines.hpp>
#include <globals.hpp>
#include <variklis/matke/matke.hpp>
#include <variklis/matke/taskas.hpp>
#include <variklis/garsas/garsas.hpp>
#include <variklis/garsas/garsai.hpp>
#include <mapas.hpp>
#include <GL/gl.h>


class KTankas
{
	public:
	static int sk;		//Sukurtu tanku skaicius
	bool	gyvas;
	int		gyvybe;
	int 	num;		//Tanko numeris
	int		x, y;		//Pozicija - uzimamo langelio kordinates
	int		xNauj, yNauj;
	KTaskas poz, pozNauj;
	int		pas,		//Tanko pasisukimo kryptis (= kampas / 90.0)
			pasNauj;	//Naujas pasisukimas
	float	vamzdisPas;	//Vamzdzio pasisukimas
	GLuint	tekst;		//Tanko tekstura
	bool	vaziuoja;
	bool	ai;			//Ar tanka valdo ai?
	//Soviniai
	float	sov;		//Soviniu skaicius
	bool	issauta;	//Ar issauta?
	KTaskas kulka;		//Kulkos pozicija
	float	kulkaPas;	//Kulkos skridimo kryptis
	float	kulkaGr;
	float	suvioLaikas;	//Kiek praejo laiko nuo paskutinio suvio
	//Susidurimai su priesais
	bool	susid;		//Ar numatomas susidurimas?
	float	susidPas;
	KTaskas	gPoz;
	int		obj;
	//Garsai
	KGarsas	gSuvis,
			gSprogimas;
	
	static KMapas	*mapas;
	
	KTankas();
	~KTankas();
	static void Init();
	void Sukurti(int, int, GLuint);
	void IjungtiAI();
	void IjungtiZaid();
	void Pataikyta();
	bool Vaziuoti();
	void IeskotiPriesu(int, int);
	void Atnaujinti();
	void Piesti();
	void Naikinti();
	//Valdymas
	bool Kairen();
	bool Desinen();
	bool Zemyn();
	bool Aukstyn();
	void Vamzdis(float);
	void Sauti();
	void NaikintiKulka();
	void Zuvo();
};


#endif
